export function formatCurrency(
    value: number,
    locale: string = 'en-US',
    currency: string = 'USD',
): string {
    if (typeof value !== 'number') {
        value = Number(value) || 0;
    }

    try {
      // Use Intl.NumberFormat directly
        return new Intl.NumberFormat(locale, {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2,
        }).format(value);
    } catch (error) {
        return `${currency} ${value
            .toFixed(0)
            .replace(/\B(?=(\d{3})+(?!\d))/g, '.')}`;
    }
}
