'use client'
import React from 'react'
import SunEditor from 'suneditor-react';
import 'suneditor/dist/css/suneditor.min.css';

interface TextEditorProps {
    value: string
    onChange: (value: string) => void
}

const TextEditor = ({ value, onChange}: TextEditorProps) => {
    const [editorState, setEditorState] = React.useState('');

    const sample =
        '<p>Add text here</p>';

    React.useEffect(() => {
        if(value){
            setEditorState(value);
        }else{
            setEditorState(sample);
        }
    }, [value]);


    const changeText = React.useCallback((value: any) => {
        setEditorState(value);
        onChange(value);
    }, [onChange]);

    return (
        <SunEditor 
            setContents={editorState} 
            onChange={changeText} 
            setDefaultStyle="font-family: figtree; font-size: 16px; min-height: 160px;"
        />
    )
}

export default TextEditor