"use client"

import React from 'react'
import {
    FormControl,
    FormField,
    FormItem,
    FormLabel,
    FormMessage,
} from "@/components/ui/form"
import { 
    Popover, 
    PopoverContent, 
    PopoverTrigger 
} from '@/components/ui/popover';
import { 
    Command, 
    CommandEmpty, 
    CommandInput, 
    CommandItem, 
    CommandList 
} from '@/components/ui/command';
import { Button } from '@/components/ui/button';
import { cn } from '@/lib/utils';
import { ArrowUpDown } from 'lucide-react';
import { Input } from '@/components/ui/input';
import { Avatar, AvatarFallback, AvatarImage } from '@/components/ui/avatar';
import { Separator } from '@/components/ui/separator';
import TextEditor from '@/components/ui/text-editor';

interface Props {
    data?: any;
    form: any
    areas: any[];
    villas: any[];
}
const MainSection = ({data, form, areas, villas}: Props) => {

    const popoverTriggerRef = React.useRef<HTMLButtonElement>(null);
    const [image, setImage] = React.useState(data?.image ? `https://imagedelivery.net/wO6ihUlg1M7aee1mES2PLg/${data.image}/public` : "");

    return (
        <div className='space-y-6 py-6 border rounded-lg'>
            <div className='grid md:grid-cols-3 md:divide-x divide-x-0 gap-3 '>
                <div className='space-y-6 px-6'>
                    <FormField
                        control={form.control}
                        name="area"
                        render={({ field }) => (
                            <FormItem className="flex flex-col">
                                <FormLabel className="w-full">Area</FormLabel>
                                <Popover>
                                    <PopoverTrigger asChild>
                                        <FormControl>
                                            <Button
                                                ref={popoverTriggerRef}
                                                variant="outline"
                                                role="combobox"
                                                className={cn(
                                                    "w-full justify-between",
                                                    !field.value && "text-muted-foreground"
                                                )}
                                            >
                                                {field.value ? 
                                                    areas.find(
                                                        (ar: any) => ar._id === field.value
                                                    )?.name
                                                    : "Select area"}
                                                <ArrowUpDown className="ml-2 h-4 w-4 shrink-0 opacity-50" />
                                            </Button>
                                        </FormControl>
                                    </PopoverTrigger>
                                    <PopoverContent className="w-full p-0">
                                    <Command className="gap-3 py-2">
                                        <CommandInput placeholder="Search area..."/>
                                        <CommandEmpty>No Area found.</CommandEmpty>
                                        <CommandList>
                                            {areas.map((ar: any) => (
                                                <CommandItem
                                                    key={ar._id}
                                                    value={ar.name}
                                                    onSelect={() => {
                                                        form.setValue("area", ar._id);
                                                        popoverTriggerRef.current?.click();
                                                    }}
                                                    className="px-3 rounded-none cursor-pointer"
                                                    >
                                                    {ar.name}
                                                </CommandItem>
                                            ))}
                                        </CommandList>
                                    </Command>
                                    </PopoverContent>
                                </Popover>
                                <FormMessage />
                            </FormItem>
                        )}
                    />
                    <FormField
                        control={form.control}
                        name="villa"
                        render={({ field }) => (
                            <FormItem className="flex flex-col">
                                <FormLabel className="w-full">Villa</FormLabel>
                                <Popover>
                                    <PopoverTrigger asChild>
                                        <FormControl>
                                            <Button
                                                ref={popoverTriggerRef}
                                                variant="outline"
                                                role="combobox"
                                                className={cn(
                                                    "w-full justify-between",
                                                    !field.value && "text-muted-foreground"
                                                )}
                                            >
                                                {field.value
                                                    ? villas.find(
                                                        (vi: any) => String(vi._id) === field.value
                                                    )?.name
                                                    : "Select villa"}
                                                <ArrowUpDown className="ml-2 h-4 w-4 shrink-0 opacity-50" />
                                            </Button>
                                        </FormControl>
                                    </PopoverTrigger>
                                    <PopoverContent className="w-full p-0">
                                    <Command className="gap-3 py-2">
                                        <CommandInput placeholder="Search villa..."/>
                                        <CommandEmpty>No villa found.</CommandEmpty>
                                        <CommandList>
                                            {villas.map((v: any) => (
                                                <CommandItem
                                                    key={v._id}
                                                    value={v.name}
                                                    onSelect={() => {
                                                        form.setValue("propertyId", String(v.propertyId) );
                                                        form.setValue("roomId", String(v.roomId) );
                                                        form.setValue("name", String(v.name) );
                                                        form.setValue("villa", String(v._id) );
                                                        form.setValue("street", v.address);
                                                        form.setValue("city", v.city);
                                                        form.setValue("latitude", String(v.latitude));
                                                        form.setValue("longitude", String(v.longitude));
                                                        popoverTriggerRef.current?.click();
                                                    }}
                                                    className="px-3 rounded-none cursor-pointer"
                                                >
                                                    {v.name}
                                                </CommandItem>
                                            ))}
                                        </CommandList>
                                    </Command>
                                    </PopoverContent>
                                </Popover>
                                <FormMessage />
                            </FormItem>
                        )}
                    />
                    <FormField
                        control={form.control}
                        name="propertyId"
                        render={({ field }) => (
                            <FormItem>
                                <FormLabel>Property ID</FormLabel>
                                <FormControl>
                                    <Input {...field} placeholder="Enter Property ID"/>
                                </FormControl>
                                <FormMessage />
                            </FormItem>
                        )}
                    />
                    <FormField
                        control={form.control}
                        name="roomId"
                        render={({ field }) => (
                            <FormItem>
                                <FormLabel>Room ID</FormLabel>
                                <FormControl>
                                    <Input {...field} placeholder="Enter Room ID"/>
                                </FormControl>
                                <FormMessage />
                            </FormItem>
                        )}
                    />
                    <FormField
                        control={form.control}
                        name="name"
                        render={({ field }) => (
                            <FormItem>
                                <FormLabel>Villa Name</FormLabel>
                                <FormControl>
                                    <Input {...field} placeholder="Enter Villa Name"/>
                                </FormControl>
                                <FormMessage />
                            </FormItem>
                        )}
                    />
                    <FormField
                        control={form.control}
                        name="offerId"
                        render={({ field }) => (
                            <FormItem>
                                <FormLabel>Offer ID {"( default : 1 )"}</FormLabel>
                                <FormControl>
                                    <Input {...field} placeholder="Enter Offer ID"/>
                                </FormControl>
                                <FormMessage />
                            </FormItem>
                        )}
                    />
                </div>
                <div className='space-y-6 px-6'>
                    <FormField
                        control={form.control}
                        name="gmaps"
                        render={({ field }) => (
                            <FormItem>
                                <FormLabel>Google Maps</FormLabel>
                                <FormControl>
                                    <Input {...field} placeholder="Enter Google Maps Link"/>
                                </FormControl>
                                <FormMessage />
                            </FormItem>
                        )}
                    />
                    <FormField
                        control={form.control}
                        name="street"
                        render={({ field }) => (
                            <FormItem>
                                <FormLabel>Street</FormLabel>
                                <FormControl>
                                    <Input {...field} placeholder="Enter Street Address"/>
                                </FormControl>
                                <FormMessage />
                            </FormItem>
                        )}
                    />
                    <FormField
                        control={form.control}
                        name="city"
                        render={({ field }) => (
                            <FormItem>
                                <FormLabel>District</FormLabel>
                                <FormControl>
                                    <Input {...field} placeholder="Enter District / City"/>
                                </FormControl>
                                <FormMessage />
                            </FormItem>
                        )}
                    />
                    <FormField
                        control={form.control}
                        name="postCode"
                        render={({ field }) => (
                            <FormItem>
                                <FormLabel>Postal Code {"( default : 80361 )"}</FormLabel>
                                <FormControl>
                                    <Input {...field} placeholder="Enter Postal Code"/>
                                </FormControl>
                                <FormMessage />
                            </FormItem>
                        )}
                    />
                    <FormField
                        control={form.control}
                        name="latitude"
                        render={({ field }) => (
                            <FormItem>
                                <FormLabel>Latitude</FormLabel>
                                <FormControl>
                                    <Input {...field} placeholder="Enter latitude"/>
                                </FormControl>
                                <FormMessage />
                            </FormItem>
                        )}
                    />
                    <FormField
                        control={form.control}
                        name="longitude"
                        render={({ field }) => (
                            <FormItem>
                                <FormLabel>Longitude</FormLabel>
                                <FormControl>
                                    <Input {...field} placeholder="Enter Longitude"/>
                                </FormControl>
                                <FormMessage />
                            </FormItem>
                        )}
                    />
                </div>
                <div className='space-y-6 px-6'>
                    <FormField
                        control={form.control}
                        name="image"
                        render={({ field: { value, onChange, ...fieldProps } }) => (
                            <FormItem>
                                <FormLabel>
                                    <div className='space-y-2 w-full'>
                                        <div className='flex items-center gap-2'>
                                            <p className='font-medium'>Main Image</p>
                                        </div>
                                        <Avatar className="w-full h-42 border drop-shadow-lg rounded-lg">
                                            <AvatarImage src={image} className="object-cover rounded-lg" />
                                            <AvatarFallback className="rounded-lg">IMG</AvatarFallback>
                                        </Avatar>
                                    </div>
                                </FormLabel>
                                <FormControl>
                                    <Input
                                        className="hidden"
                                        {...fieldProps}
                                        placeholder="Picture"
                                        type="file"
                                        accept="image/*, application/pdf"
                                        onChange={(event) => {
                                            const files = event.target.files;
                                            if (files && files.length > 0) {
                                                const displayUrl = URL.createObjectURL(files[0]);
                                                const selectedFile = files[0];
                                                form.setValue("image", selectedFile)
                                                setImage(displayUrl)
                                            }
                                        }}
                                    />
                                </FormControl>
                                <FormMessage />
                            </FormItem>
                        )}
                    />
                    <Separator />
                    <FormField
                        control={form.control}
                        name="maxGuest"
                        render={({ field }) => (
                            <FormItem>
                                <div className='flex items-center gap-2'>
                                    <FormLabel>Max Guest</FormLabel>
                                </div>
                                <FormControl>
                                    <Input {...field} placeholder="Enter Max Guest"/>
                                </FormControl>
                            </FormItem>
                        )}
                    />
                    <FormField
                        control={form.control}
                        name="bedrooms"
                        render={({ field }) => (
                            <FormItem>
                                <div className='flex items-center gap-2'>
                                    <FormLabel>Bedroom</FormLabel>
                                </div>
                                <FormControl>
                                    <Input {...field} placeholder="Enter Bedroom"/>
                                </FormControl>
                            </FormItem>
                        )}
                    />
                    <FormField
                        control={form.control}
                        name="bathrooms"
                        render={({ field }) => (
                            <FormItem>
                                <div className='flex items-center gap-2'>
                                    <FormLabel>Bathroom</FormLabel>
                                </div>
                                <FormControl>
                                    <Input {...field} placeholder="Enter Bathroom"/>
                                </FormControl>
                            </FormItem>
                        )}
                    />
                </div>
            </div>
            <div className='px-6'>
                <Separator />
            </div>
            <div className="space-y-2 md:px-6 px-0">
                <FormField
                    control={form.control}
                    name="description"
                    render={({ field }) => (
                        <FormItem>
                            <div className='flex items-center gap-2'>
                                <FormLabel>Description</FormLabel>
                            </div>
                            <FormControl>
                                <TextEditor {...field}/>
                            </FormControl>
                        </FormItem>
                    )}
                />
            </div>
        </div>
    )
}

export default MainSection