"use client"

import React from 'react'
import {
    FormControl,
    FormField,
    FormItem,
} from "@/components/ui/form"
import Image from 'next/image'
import { Toggle } from '@/components/ui/toggle'

interface Props {
    form: any
}
const AmenitiesSection = ({form}: Props) => {
    return (
        <div className="grid md:grid-cols-6 grid-cols-2 gap-4 md:px-6 py-6 border rounded-lg">
            <FormField
                control={form.control}
                name="airport"
                render={({ field }) => (
                    <FormItem>
                        <FormControl >
                            <Toggle size="card" variant="blue" pressed={field.value} onPressedChange={field.onChange}>
                                <Image src='/amenity/airport.svg' alt="airport" width={24} height={24}/>
                                <span>Near Airport</span>
                            </Toggle>
                        </FormControl>
                    </FormItem>
                )}
            />
            <FormField
                control={form.control}
                name="aircond"
                render={({ field }) => (
                    <FormItem>
                        <FormControl >
                            <Toggle size="card" variant="blue" pressed={field.value} onPressedChange={field.onChange}>
                                <Image src='/amenity/ac.svg' alt="aircond" width={24} height={24}/>
                                <span>Air conditioner</span>
                            </Toggle>
                        </FormControl>
                    </FormItem>
                )}
            />
            <FormField
                control={form.control}
                name="kitchen"
                render={({ field }) => (
                    <FormItem>
                        <FormControl >
                            <Toggle size="card" variant="blue" pressed={field.value} onPressedChange={field.onChange}>
                                <Image src='/amenity/kitchen.svg' alt="kitchen" width={24} height={24}/>
                                <span>Kitchen</span>
                            </Toggle>
                        </FormControl>
                    </FormItem>
                )}
            />
            <FormField
                control={form.control}
                name="smokeDetector"
                render={({ field }) => (
                    <FormItem>
                        <FormControl >
                            <Toggle size="card" variant="blue" pressed={field.value} onPressedChange={field.onChange}>
                                <Image src='/amenity/smoke_alarm.svg' alt="smoke_detector" width={24} height={24}/>
                                <span>Smoke Detector</span>
                            </Toggle>
                        </FormControl>
                    </FormItem>
                )}
            />
            <FormField
                control={form.control}
                name="internet"
                render={({ field }) => (
                    <FormItem>
                        <FormControl >
                            <Toggle size="card" variant="blue" pressed={field.value} onPressedChange={field.onChange}>
                                <Image src='/amenity/wifi.svg' alt="internet" width={24} height={24}/>
                                <span>Internet</span>
                            </Toggle>
                        </FormControl>
                    </FormItem>
                )}
            />
            <FormField
                control={form.control}
                name="workdesk"
                render={({ field }) => (
                    <FormItem>
                        <FormControl >
                            <Toggle size="card" variant="blue" pressed={field.value} onPressedChange={field.onChange}>
                                <Image src='/amenity/workdesk.svg' alt="workdesk" width={24} height={24}/>
                                <span>Workdesk</span>
                            </Toggle>
                        </FormControl>
                    </FormItem>
                )}
            />
            <FormField
                control={form.control}
                name="essentials"
                render={({ field }) => (
                    <FormItem>
                        <FormControl >
                            <Toggle size="card" variant="blue" pressed={field.value} onPressedChange={field.onChange}>
                                <Image src='/amenity/essentials.svg' alt="essentials" width={24} height={24}/>
                                <span>Essentials</span>
                            </Toggle>
                        </FormControl>
                    </FormItem>
                )}
            />
            <FormField
                control={form.control}
                name="hairdryer"
                render={({ field }) => (
                    <FormItem>
                        <FormControl >
                            <Toggle size="card" variant="blue" pressed={field.value} onPressedChange={field.onChange}>
                                <Image src='/amenity/hair_dryer.svg' alt="hairdryer" width={24} height={24}/>
                                <span>Hairdryer</span>
                            </Toggle>
                        </FormControl>
                    </FormItem>
                )}
            />
            <FormField
                control={form.control}
                name="hangers"
                render={({ field }) => (
                    <FormItem>
                        <FormControl >
                            <Toggle size="card" variant="blue" pressed={field.value} onPressedChange={field.onChange}>
                                <Image src='/amenity/hangers.svg' alt="hangers" width={24} height={24}/>
                                <span>Hangers</span>
                            </Toggle>
                        </FormControl>
                    </FormItem>
                )}
            />
            <FormField
                control={form.control}
                name="shampoo"
                render={({ field }) => (
                    <FormItem>
                        <FormControl >
                            <Toggle size="card" variant="blue" pressed={field.value} onPressedChange={field.onChange}>
                                <Image src='/amenity/shampoo.svg' alt="shampoo" width={24} height={24}/>
                                <span>Shampoo</span>
                            </Toggle>
                        </FormControl>
                    </FormItem>
                )}
            />
            <FormField
                control={form.control}
                name="pool"
                render={({ field }) => (
                    <FormItem>
                        <FormControl >
                            <Toggle size="card" variant="blue" pressed={field.value} onPressedChange={field.onChange}>
                                <Image src='/amenity/pool.svg' alt="pool" width={24} height={24}/>
                                <span>Swimming Pool</span>
                            </Toggle>
                        </FormControl>
                    </FormItem>
                )}
            />
            <FormField
                control={form.control}
                name="parking"
                render={({ field }) => (
                    <FormItem>
                        <FormControl >
                            <Toggle size="card" variant="blue" pressed={field.value} onPressedChange={field.onChange}>
                                <Image src='/amenity/parking.svg' alt="parking" width={24} height={24}/>
                                <span>Parking on premise</span>
                            </Toggle>
                        </FormControl>
                    </FormItem>
                )}
            />
            <FormField
                control={form.control}
                name="backyard"
                render={({ field }) => (
                    <FormItem>
                        <FormControl >
                            <Toggle size="card" variant="blue" pressed={field.value} onPressedChange={field.onChange}>
                                <Image src='/amenity/backyard.svg' alt="backyard" width={24} height={24}/>
                                <span>Backyard</span>
                            </Toggle>
                        </FormControl>
                    </FormItem>
                )}
            />
            <FormField
                control={form.control}
                name="tv"
                render={({ field }) => (
                    <FormItem>
                        <FormControl >
                            <Toggle size="card" variant="blue" pressed={field.value} onPressedChange={field.onChange}>
                                <Image src='/amenity/tv.svg' alt="tv" width={24} height={24}/>
                                <span>TV</span>
                            </Toggle>
                        </FormControl>
                    </FormItem>
                )}
            />
            <FormField
                control={form.control}
                name="gym"
                render={({ field }) => (
                    <FormItem>
                        <FormControl >
                            <Toggle size="card" variant="blue" pressed={field.value} onPressedChange={field.onChange}>
                                <Image src='/amenity/gym.svg' alt="gym" width={24} height={24}/>
                                <span>GYM</span>
                            </Toggle>
                        </FormControl>
                    </FormItem>
                )}
            />
            <FormField
                control={form.control}
                name="spa"
                render={({ field }) => (
                    <FormItem>
                        <FormControl >
                            <Toggle size="card" variant="blue" pressed={field.value} onPressedChange={field.onChange}>
                                <Image src='/amenity/spa.svg' alt="spa" width={24} height={24}/>
                                <span>Spa</span>
                            </Toggle>
                        </FormControl>
                    </FormItem>
                )}
            />
        </div>
    )
}

export default AmenitiesSection