"use client"

import React from 'react'
import {
    FormControl,
    FormField,
    FormItem,
    FormLabel,
    FormMessage,
} from "@/components/ui/form"
import { Button } from '@/components/ui/button'
import { Textarea } from '@/components/ui/textarea'

interface Props {
    form: any
    areas: any[];
}

const AdditionalSection = ({form, areas}: Props) => {

    const metaDescriptionsGenerator = () => {
        const villaname = form.getValues('name') || 'this stunning villa';
        const bedrooms = form.getValues('bedrooms') || 'multiple';
        const area = form.getValues('area') || []; // Ensure area is an array
        const maxGuest = form.getValues('maxGuest') || 'a group of';
    
        // Determine area name
        const areaName = Array.isArray(areas)
        ? areas.find((ar: any) => ar._id === area)?.name || 'a beautiful location'
        : 'a beautiful location';

        // Meta description templates
        const templates = [
            `Stay at ${villaname}, a ${bedrooms} bedroom villa in ${areaName} for your memorable holiday. Max. guests ${maxGuest} people. BOOK NOW with The Tropical Door Bali`,
            `Discover ${villaname}, a ${bedrooms} bedroom villa in ${areaName} for your luxury vacation. Max. guests ${maxGuest} people. BOOK NOW with The Tropical Door Bali`,
            `Enjoy ${villaname}, a ${bedrooms} bedroom villa in ${areaName} for your luxury trip. Max. guests ${maxGuest} people. BOOK NOW with The Tropical Door Bali`,
        ];

        return templates[Math.floor(Math.random() * templates.length)];
    };
    
    const generateTitle = () => {
        const villaname = form.getValues('name') || 'Villa';
        const bedrooms = form.getValues('bedrooms') || '0';
        const area = form.getValues('area') || [];

        const areaName = Array.isArray(areas)
        ? areas.find((ar: any) => ar._id === area)?.name || 'a beautiful location'
        : 'a beautiful location';


        const text = `${villaname} : ${bedrooms} Bedroom Villa in ${areaName} for RENT`;

        form.setValue("titleTag", text);
    }
    const generateMeta = () => {
        const text = metaDescriptionsGenerator()
        form.setValue("metaDesc", text);
    }

    return (
            <div className='md:px-6 space-y-6 border rounded-lg py-6'>
                <FormField
                    control={form.control}
                    name="titleTag"
                    render={({ field }) => (
                        <FormItem>
                            <FormLabel>Title</FormLabel>
                            <div className="flex items-center gap-2">
                                <FormControl>
                                    <Textarea {...field}/>
                                </FormControl>
                                <Button type="button" className='h-full max-h-16' onClick={generateTitle}>Generate</Button>
                            </div>
                            <FormMessage />
                        </FormItem>
                    )}
                />
                <FormField
                    control={form.control}
                    name="metaDesc"
                    render={({ field }) => (
                        <FormItem>
                            <FormLabel>Meta Description</FormLabel>
                            <div className="flex items-center gap-2">
                                <FormControl>
                                    <Textarea {...field}/>
                                </FormControl>
                                <Button type="button" className='h-full max-h-16' onClick={generateMeta}>Generate</Button>
                            </div>
                            <FormMessage />
                        </FormItem>
                    )}
                />
            </div>
    )
}

export default AdditionalSection