"use client"

import React from 'react'
import { Button } from '@/components/ui/button'
import {
    Sheet,
    SheetContent,
    SheetDescription,
    SheetHeader,
    SheetTitle,
    SheetTrigger,
} from "@/components/ui/sheet"
import { LogOutIcon, MenuIcon } from 'lucide-react'
import Link from 'next/link'
import {
    Collapsible,
    CollapsibleContent,
    CollapsibleTrigger,
} from "@/components/ui/collapsible"
import { Separator } from '@/components/ui/separator'

import { ChevronRight} from 'lucide-react'
import { navMenu } from '@/lib/nav'
import { usePathname } from 'next/navigation'

const SiteHeader = () => {
    const path = usePathname();
    const [openSections, setOpenSections] = React.useState<{ [key: string]: boolean }>({});

    React.useEffect(() => {
        const initialState: { [key: string]: boolean } = {};
        navMenu.forEach((nav) => {
            if (nav.items.some((item) => item.url === path)) {
                initialState[nav.title] = true;
            }
        });
        setOpenSections(initialState);
    }, [path]);

    const toggleSection = (title: string) => {
        setOpenSections((prev) => ({
            ...prev,
            [title]: !prev[title],
        }));
    };
    return (
        <div className='bg-background sticky top-0 z-50 flex w-full items-center border-b shadow-xs'>
            <div className="flex h-auto w-full items-center gap-3 lg:px-14 px-4 py-4">
                <div className='shrink lg:hidden block'>
                    <Sheet>
                        <SheetTrigger asChild>
                            <Button variant="black">
                                <MenuIcon />
                            </Button>
                        </SheetTrigger>
                        <SheetContent className='bg-gundam-black text-white'>
                            <SheetHeader className='sr-only'>
                                <SheetTitle>Are you absolutely sure?</SheetTitle>
                                <SheetDescription>
                                    This action cannot be undone. This will permanently delete your account
                                    and remove your data from our servers.
                                </SheetDescription>
                            </SheetHeader>
                            <div className='grow flex flex-col gap-2 p-2'>
                                <div className='aspect-video w-full flex items-center justify-center p-2'>
                                    <Link href="/">
                                        <h1 className='font-bold text-xl'>ADMIN PANEL</h1>
                                    </Link>
                                </div>
                                <div className='px-2'>
                                    <Separator color='white' />
                                </div>
                                <div className='flex min-h-0 flex-1 flex-col gap-2 overflow-auto'>
                                    {navMenu.map((nav) => (
                                        <Collapsible key={nav.title} open={openSections[nav.title] || false} onOpenChange={() => toggleSection(nav.title)}>
                                            <CollapsibleTrigger asChild>
                                                <Link href={nav.url} className='group flex items-center justify-between w-full p-3'>
                                                    <span className={path === nav.url ? "font-bold" : ""}>{nav.title}</span>
                                                    {nav.items.length > 0 && (
                                                        <ChevronRight size={18} className="transition-transform duration-200 group-data-[state=open]:rotate-90"/>
                                                    )}
                                                </Link>
                                            </CollapsibleTrigger>
                                            {nav.items.length > 0 ? (
                                                <CollapsibleContent>
                                                    <ul className='flex w-full min-w-0 flex-col gap-1 p-2'>
                                                        {nav.items.map((item) => (
                                                            <li key={item.title} className='group/menu-item relative'>
                                                                <Button className='justify-start' variant={path === item.url ? "active" : "menu"} asChild>
                                                                    <Link href={item.url} className='w-full'>
                                                                        <item.icon />
                                                                        <span>{item.title}</span>
                                                                    </Link>
                                                                </Button>
                                                            </li>
                                                        ))}
                                                    </ul>
                                                </CollapsibleContent>
                                            ) : null }
                                        </Collapsible>
                                    ))}
                                </div>
                            </div>
                        </SheetContent>
                    </Sheet>
                </div>
                <div className='grow flex items-center justify-end'>
                    <Button variant="blue">
                        <LogOutIcon />
                    </Button>
                </div>
            </div>
        </div>
    )
}

export default SiteHeader