"use client"

import React from 'react'
import Image from 'next/image'
import Link from 'next/link'
import { usePathname } from 'next/navigation'

import {
    Collapsible,
    CollapsibleContent,
    CollapsibleTrigger,
} from "@/components/ui/collapsible"
import { Button } from '@/components/ui/button'
import { Separator } from '@/components/ui/separator'

import { ChevronRight} from 'lucide-react'
import { navMenu } from '@/lib/nav'

const SidebarApp = () => {
    const path = usePathname();
    const [openSections, setOpenSections] = React.useState<{ [key: string]: boolean }>({});

    React.useEffect(() => {
        const initialState: { [key: string]: boolean } = {};
        navMenu.forEach((nav) => {
            if (nav.items.some((item) => item.url === path)) {
                initialState[nav.title] = true;
            }
        });
        setOpenSections(initialState);
    }, [path]);

    const toggleSection = (title: string) => {
        setOpenSections((prev) => ({
            ...prev,
            [title]: !prev[title],
        }));
    };
    return (
        <div className="group peer hidden text-sidebar-foreground lg:block">
            <div className='relative h-svh w-3xs bg-transparent'>
                <div className='fixed inset-y-0 z-10 hidden w-3xs h-svh lg:flex left-0 '>
                    <div className='flex h-full w-full flex-col bg-gundam-black text-white'>
                        <div className='grow flex flex-col gap-2 p-2'>
                            <div className='aspect-square w-full flex items-center justify-center p-2'>
                                <Link href="/">
                                    <h1 className='font-bold text-xl'>ADMIN PANEL</h1>
                                </Link>
                            </div>
                            <div className='px-2'>
                                <Separator color='white' />
                            </div>
                            <div className='flex min-h-0 flex-1 flex-col gap-2 overflow-auto'>
                                {navMenu.map((nav) => (
                                    <Collapsible key={nav.title} open={openSections[nav.title] || false} onOpenChange={() => toggleSection(nav.title)}>
                                        <CollapsibleTrigger asChild>
                                            <Link href={nav.url} className='group flex items-center justify-between w-full p-3'>
                                                <span className={path === nav.url ? "font-bold" : ""}>{nav.title}</span>
                                                {nav.items.length > 0 && (
                                                    <ChevronRight size={18} className="transition-transform duration-200 group-data-[state=open]:rotate-90"/>
                                                )}
                                            </Link>
                                        </CollapsibleTrigger>
                                        {nav.items.length > 0 ? (
                                            <CollapsibleContent>
                                                <ul className='flex w-full min-w-0 flex-col gap-1 p-2'>
                                                    {nav.items.map((item) => (
                                                        <li key={item.title} className='group/menu-item relative'>
                                                            <Button className='justify-start' variant={path === item.url ? "active" : "menu"} asChild>
                                                                <Link href={item.url} className='w-full'>
                                                                    <item.icon />
                                                                    <span>{item.title}</span>
                                                                </Link>
                                                            </Button>
                                                        </li>
                                                    ))}
                                                </ul>
                                            </CollapsibleContent>
                                        ) : null }
                                    </Collapsible>
                                ))}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    )
}

export default SidebarApp