"use client"

import { useLoading } from "@/lib/useLoading";
import { Loader2Icon } from "lucide-react";

const Loading = () => {
    const { loading } = useLoading();

    if (!loading) return null;

    return (
        <div className="fixed top-0 left-0 bg-black/30 w-full h-full z-50 flex items-center justify-center">
            <div className='bg-gray-100 h-28 w-28 flex items-center justify-center rounded-full'>
                <Loader2Icon 
                    size={80}
                    strokeWidth={3}
                    className="animate-spin"
                />
            </div>
        </div>
    );
};

export default Loading;
