"use client"
import React from 'react'
import {
    AlertDialog,
    AlertDialogAction,
    AlertDialogCancel,
    AlertDialogContent,
    AlertDialogDescription,
    AlertDialogFooter,
    AlertDialogHeader,
    AlertDialogTitle,
    AlertDialogTrigger,
} from "@/components/ui/alert-dialog"
import { Button } from '@/components/ui/button'
import { Send } from 'lucide-react';
import { Input } from '@/components/ui/input';

interface Props {
    variant: any;
    disabled: boolean;
    onAction: () => void;
}

const SendBooking = ({variant, disabled, onAction}: Props) => {
    const [text , setText] = React.useState("")
    const [input, setInput] = React.useState("");
    const [error, setError] = React.useState(true);
    const generateText = () => {
        const newText = Math.random().toString(36).substring(2, 9).toUpperCase();
        setText(newText);
        setInput(""); // reset input when dialog opens
    };

    React.useEffect(() => {
        if (input === text) {
            setError(false)
        }else{
            setError(true)
        }
    },[text, input])
    return (
        <AlertDialog onOpenChange={(open) => open && generateText()}>
            <AlertDialogTrigger asChild>
                <Button 
                    size="sm" 
                    variant={variant} 
                    disabled={disabled}
                >
                    <Send />
                    <span className='text-[13px]'>Book</span>
                </Button>
            </AlertDialogTrigger>
            <AlertDialogContent className='w-[400px]'>
                <AlertDialogHeader>
                    <AlertDialogTitle>Do you wish to send this data to Beds24 ?</AlertDialogTitle>
                    <AlertDialogDescription className='sr-only'>
                        This action cannot be undone. This will permanently delete your account
                        and remove your data from our servers.
                    </AlertDialogDescription>
                </AlertDialogHeader>
                <div className='space-y-1.5'>
                    <p className='text-sm leading-6'>To send the data booking, type {`"`}<strong>{text}</strong>{`"`} to the input field below.</p>
                    <Input
                        type="text"
                        className="border border-gray-300 rounded px-2 py-1 w-full text-sm"
                        value={input}
                        placeholder='Enter the text'
                        onChange={(e) => setInput(e.target.value.toUpperCase())}
                    />
                </div>
                <AlertDialogFooter>
                    <AlertDialogCancel>Cancel</AlertDialogCancel>
                    <AlertDialogAction disabled={error} onClick={onAction}>Continue</AlertDialogAction>
                </AlertDialogFooter>
            </AlertDialogContent>
        </AlertDialog>

    )
}

export default SendBooking