"use client"

import React from 'react'
import {
    Popover,
    PopoverContent,
    PopoverTrigger,
} from "@/components/ui/popover"
import { Hash, InfoIcon, Mail, Phone, User } from 'lucide-react'
import { Button } from '@/components/ui/button'
import moment from 'moment-timezone'
import { Separator } from '@/components/ui/separator'

interface Props {
    data: any;
}
const BookingDetail = ({data}: Props) => {
    return (
        <Popover>
            <PopoverTrigger asChild>
                <Button>
                    <InfoIcon />
                </Button>
            </PopoverTrigger>
            <PopoverContent className='w-80'>
                <div className='text-sm space-y-3'>
                    <h3 className=' font-semibold'>Booking Details {data.paid && `(${moment(data.updatedAt).tz("Asia/Makassar").fromNow()})`}</h3>
                    <ul className='space-y-2'>
                        <li className='flex items-center gap-2'>
                            <Hash size={16}/>
                            <p className='font-semibold'>{data.bookId}</p>
                        </li>
                        <li className='flex items-center gap-2'>
                            <User size={16}/>
                            <p>{data.firstname} {data.lastname}</p>
                        </li>
                        <li className='flex items-center gap-2'>
                            <Mail size={16}/>
                            <p>{data.email}</p>
                        </li>
                        <li className='flex items-center gap-2'>
                            <Phone size={16}/>
                            <p>{data.phone}</p>
                        </li>
                    </ul>
                    <Separator />
                    <ul className='list-disc list-inside space-y-2'>
                        <li>Created Date : <strong>{moment(data.createdAt).tz("Asia/Makassar").format("DD MMM YYYY, hh:mm A")}</strong></li>
                        <li>Booking Date : <strong>{data.paid ? moment(data.updatedAt).tz("Asia/Makassar").format("DD MMM YYYY, hh:mm A") : "-"}</strong></li>
                        <li>USD Price : <strong>{data.usd.toLocaleString()} USD</strong></li>
                        <li>IDR Price : <strong>{data.idr.toLocaleString()} IDR</strong></li>
                    </ul>
                </div>
            </PopoverContent>
        </Popover>

    )
}

export default BookingDetail