import MainContent from "@/components/sidebar/main-content";
import SidebarApp from "@/components/sidebar/sidebar-app";
import SidebarWrapper from "@/components/sidebar/sidebar-wrapper";
import SiteHeader from "@/components/sidebar/site-header";
import { Button } from "@/components/ui/button";
import {
    Card,
    CardContent,
    CardDescription,
    CardHeader,
    CardTitle,
} from "@/components/ui/card"
import { BookOpenCheckIcon, HouseIcon, KeyRoundIcon, MapPinHouseIcon } from "lucide-react";
import Image from "next/image";
import Link from "next/link";


export default function page() {
    return (
        <div className="[--header-height:calc(--spacing(14))]">
            <SidebarWrapper>
                <div className="flex flex-1">
                    <SidebarApp/>
                    <MainContent>
                        <SiteHeader/>
                        <div className="flex flex-1 flex-col gap-6 lg:px-14 px-4 py-8 bg-gundam-gray/30">
                            <div className="grid md:grid-cols-2 gap-6 mx-auto">
                                <Card className="w-md py-0 gap-0">
                                    <CardHeader className="sr-only">
                                        <CardTitle>Card Title</CardTitle>
                                        <CardDescription>Card Description</CardDescription>
                                    </CardHeader>
                                    <div className="bg-orange-500 h-24 w-full rounded-t-lg flex items-center justify-center">
                                        <Image 
                                            src="/images/bmv-white.png"
                                            width={500}
                                            height={500}
                                            alt="ttd-logo"
                                            className="w-[250px] h-auto"
                                        />
                                    </div>
                                    <CardContent className="p-6 space-y-6">
                                        <h3>All of villas managed by Bali management villas</h3>
                                        <ul className="list-disc list-inside space-y-2">
                                            <li>
                                                <Button variant="ghost" asChild>
                                                    <Link href="/dashboard/bmv/villas">
                                                        <HouseIcon/>
                                                        All Villas
                                                    </Link>
                                                </Button>
                                            </li>
                                            <li>
                                                <Button variant="ghost" asChild>
                                                    <Link href="/dashboard/bmv/reservations">
                                                        <BookOpenCheckIcon />
                                                        Reservations
                                                    </Link>
                                                </Button>
                                            </li>
                                            <li>
                                                <Button variant="ghost" asChild>
                                                    <Link href="/dashboard/bmv/token">
                                                        <KeyRoundIcon />
                                                        Token
                                                    </Link>
                                                </Button>
                                            </li>
                                        </ul>
                                    </CardContent>
                                </Card>
                                <Card className="w-md py-0 gap-0">
                                    <CardHeader className="sr-only">
                                        <CardTitle>Card Title</CardTitle>
                                        <CardDescription>Card Description</CardDescription>
                                    </CardHeader>
                                    <div className="bg-[#a58e71] h-24 w-full rounded-t-lg flex items-center justify-center">
                                        <Image 
                                            src="/images/ttd-white.png"
                                            width={500}
                                            height={500}
                                            alt="ttd-logo"
                                            className="w-[300px] h-auto"
                                        />
                                    </div>
                                    <CardContent className="p-6 space-y-6">
                                        <h3>All of villas on The Tropical Door Website</h3>
                                        <ul className="list-disc list-inside space-y-2">
                                            <li>
                                                <Button variant="ghost" asChild>
                                                    <Link href="/dashboard/ttd/areas">
                                                        <MapPinHouseIcon />
                                                        All Areas
                                                    </Link>
                                                </Button>
                                            </li>
                                            <li>
                                                <Button variant="ghost" asChild>
                                                    <Link href="/dashboard/ttd/villas">
                                                        <HouseIcon />
                                                        All Villas
                                                    </Link>
                                                </Button>
                                            </li>
                                            <li>
                                                <Button variant="ghost" asChild>
                                                    <Link href="/dashboard/ttd/reservations">
                                                        <BookOpenCheckIcon />
                                                        Reservations
                                                    </Link>
                                                </Button>
                                            </li>
                                        </ul>
                                    </CardContent>
                                </Card>
                            </div>
                        </div>
                    </MainContent>
                </div>
            </SidebarWrapper>
        </div>
    );
}
