import type { Metadata } from "next";
import { Figtree } from "next/font/google";
import "./globals.css";
import { Toaster } from "sonner";

const figTree = Figtree({
  variable: "--font-figtree-sans",
  subsets: ["latin"],
});

export const metadata: Metadata = {
  title: "Direct Booking System",
  description: "Direct Booking System",
  robots: {
    index: false,
    follow: false,
  },
  icons: {
    icon: '/images/favicon.png',
  },
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en">
      <body
        className={`${figTree.variable} antialiased`}
      >
        {children}
        <Toaster richColors position="top-center"/>
      </body>
    </html>
  );
}
