
import { getRawProperties } from '@/actions/bmv'
import { getAllAreas } from '@/actions/ttd'
import MainContent from '@/components/sidebar/main-content'
import SidebarApp from '@/components/sidebar/sidebar-app'
import SidebarWrapper from '@/components/sidebar/sidebar-wrapper'
import SiteHeader from '@/components/sidebar/site-header'
import AddForm from '@/components/ttd/villas/add-form'

export default async function page() {

    const [areaData, villaData] = await Promise.all([
        getAllAreas(),
        getRawProperties()
    ])

    const areas = areaData.success ? areaData.data : [];
    const villas = villaData.success ? villaData.data : [];

    return (
        <div className="[--header-height:calc(--spacing(14))]">
            <SidebarWrapper>
                <div className="flex flex-1">
                    <SidebarApp/>
                    <MainContent>
                        <SiteHeader/>
                        <div className="flex flex-1 flex-col gap-6 lg:px-14 px-4 py-8 bg-gundam-gray/30">
                            <AddForm areas={areas} villas={villas}/>
                        </div>
                    </MainContent>
                </div>
            </SidebarWrapper>
        </div>
    )
}
