import { getRawProperties } from '@/actions/bmv'
import AddVillas from '@/components/bmv/villas/add-villas'
import MainContent from '@/components/sidebar/main-content'
import SidebarApp from '@/components/sidebar/sidebar-app'
import SidebarWrapper from '@/components/sidebar/sidebar-wrapper'
import SiteHeader from '@/components/sidebar/site-header'

export default async function page() {


    const res = await getRawProperties()
    const error = res.success ? false : true;
    const villa = res.success ? res.data : [];

    return (
        <div className="[--header-height:calc(--spacing(14))]">
            <SidebarWrapper>
                <div className="flex flex-1">
                    <SidebarApp/>
                    <MainContent>
                        <SiteHeader/>
                        <div className="flex flex-1 flex-col gap-6 lg:px-14 px-4 py-8 bg-gundam-gray/30">
                            <AddVillas 
                                villas={villa}
                            />
                        </div>
                    </MainContent>
                </div>
            </SidebarWrapper>
        </div>
    )
}
