"use server"

export async function getAllAreas() {
    try {
        const url = `${process.env.TTD_URL}/areas`
        const response = await fetch(url, {
            headers: {
                "Accept" : "application/json",
            }
        })

        const data = await response.json()

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function getAreas(offset: Number, search: String) {
    try {
        const body = {
            offset: offset,
            search: search
        }
        const url = `${process.env.TTD_URL}/paginated/areas`
        const response = await fetch(url, {
            method: "POST",
            body: JSON.stringify(body),
            headers: {
                "Accept" : "application/json",
                "Content-Type": "application/json"
            }
        })

        const data = await response.json()

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function addArea(body: FormData) {
    try {
        const url = `${process.env.TTD_URL}/areas`
        const response = await fetch(url, {
            method: "POST",
            body,
            headers: {
                "Accept" : "application/json",
            }
        })
        const data = await response.json();

        return data
    } catch (error: any) {
        console.log(error)
        return { success: false, message: JSON.stringify(error, null, 2)}
    }
}

export async function editArea(id: string, body: FormData) {
    try {
        const url = `${process.env.TTD_URL}/areas/${id}`
        const response = await fetch(url, {
            method: "PATCH",
            body,
            headers: {
                "Accept" : "application/json",
            }
        })

        const data = await response.json();

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function deleteArea(id: string) {
    try {
        const url = `${process.env.TTD_URL}/areas/${id}`
        const response = await fetch(url, {
            method: "DELETE",
            headers: {
                "Accept" : "application/json",
            }
        })

        const data = await response.json();

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function getVillas(offset: Number, search: String) {
    try {
        const body = {
            offset: offset,
            search: search
        }
        const url = `${process.env.TTD_URL}/paginated/villas`
        const response = await fetch(url, {
            method: "POST",
            body: JSON.stringify(body),
            headers: {
                "Accept" : "application/json",
                "Content-Type": "application/json"
            }
        })

        const data = await response.json()

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function addVilla(body: FormData) {
    try {
        const url = `${process.env.TTD_URL}/villas`
        const response = await fetch(url, {
            method: "POST",
            body,
            headers: {
                "Accept" : "application/json",
            }
        })

        const data = await response.json()

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function getOneVilla(id: string) {
    try {
        const url = `${process.env.TTD_URL}/villas/${id}`
        const response = await fetch(url, {
            headers: {
                "Accept" : "application/json",
            }
        })

        const data = await response.json()

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function updateVilla(id: string, body: FormData) {
    try {
        const url = `${process.env.TTD_URL}/villas/${id}`
        const response = await fetch(url, {
            method: "PATCH",
            body,
            headers: {
                "Accept" : "application/json",
            }
        })

        const data = await response.json()

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function deleteVilla(id: string) {
    try {
        const url = `${process.env.TTD_URL}/villas/${id}`
        const response = await fetch(url, {
            method: "DELETE",
            headers: {
                "Accept" : "application/json",
            }
        })

        const data = await response.json()

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function updateStatus(id: string, body: any) {
    try {
        const url = `${process.env.TTD_URL}/villas/status/${id}`
        const response = await fetch(url, {
            method: "PATCH",
            body: JSON.stringify(body),
            headers: {
                "Accept" : "application/json",
                "Content-Type": "application/json"
            }
        })

        const data = await response.json();

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function updatePrice(id: string) {
    try {
        const url = `${process.env.TTD_URL}/sync/rates/${id}`
        const response = await fetch(url, {
            headers: {
                "Accept" : "application/json",
            }
        })
        
        const data = await response.json();

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function galleryVilla(id: string) {
    try {
        const url = `${process.env.TTD_URL}/gallery/${id}`
        const response = await fetch(url, {
            headers: {
                "Accept" : "application/json",
            }
        })

        const data = await response.json();

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function addGallery(body: FormData) {
    try {
        const url = `${process.env.TTD_URL}/gallery`
        const response = await fetch(url, {
            method: "POST",
            body,
            headers: {
                "Accept" : "application/json",
            }
        })

        const data = await response.json();

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export const updateGallery = async (id: string, body: any) => {
    try {
        const url = `${process.env.TTD_URL}/gallery/${id}`;

        const response = await fetch(url,{
            method: "PATCH",
            body: JSON.stringify(body),
            headers: {
                "Accept" : "application/json",
                "Content-Type": "application/json"
            }            
        })

        if (!response.ok) {
            throw new Error(`HTTP error! Status: ${response.status}`);
        }

        const data = await response.json();
        return data
    } catch (error) {
        return { success: false, message: "An Error Occured"}
    }
}

export async function syncGallery(id: string) {
    try {
        const url = `${process.env.TTD_URL}/sync/gallery/${id}`
        const response = await fetch(url, {
            headers: {
                "Accept" : "application/json",
            }
        })

        const data = await response.json();

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export const deleteGallery = async (body: any) => {
    try {
        const url = `${process.env.TTD_URL}/gallery/delete`;

        const response = await fetch(url,{
            method: "POST",
            body: JSON.stringify(body),
            headers: {
                "Accept" : "application/json",
                "Content-Type": "application/json"
            }
        })

        const data = await response.json();
        return data
    } catch (error) {
        return { success: false, message: "An Error Occured"}
    }
}

export async function getReservations(offset: Number, search: String) {
    try {
        const body = {
            offset: offset,
            search: search
        }
        const url = `${process.env.TTD_URL}/paginated/reservations`
        const response = await fetch(url, {
            method: "POST",
            body: JSON.stringify(body),
            headers: {
                "Accept" : "application/json",
                "Content-Type": "application/json"
            }
        })

        const data = await response.json()

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function deleteReservations(id: string) {
    try {
        const url = `${process.env.TTD_URL}/reservations/${id}`
        const response = await fetch(url, {
            method: "DELETE",
            headers: {
                "Accept" : "application/json",
            }
        })

        const data = await response.json()

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function bookReservations(body: any) {
    try {
        const url = `${process.env.TTD_URL}/api/webhook/booking`

        const response = await fetch(url, {
            method: "POST",
            body: JSON.stringify(body),
            headers: {
                "Accept" : "application/json",
                'Content-Type': "application/json"
            }
        })

        const data = await response.json()

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function getHistory(date: string) {
    try {
        const url = `${process.env.TTD_URL}/history?date=${date}`
        const response = await fetch(url, {
            headers: {
                "Accept" : "application/json",
            }
        })

        const data = await response.json()

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function getToken(offset: Number, search: String) {
    try {
        const body = {
            offset: offset,
            search: search
        }
        const url = `${process.env.TTD_URL}/paginated/tokens`
        const response = await fetch(url, {
            method: "POST",
            body: JSON.stringify(body),
            headers: {
                "Accept" : "application/json",
                "Content-Type": "application/json"
            }
        })

        const data = await response.json()

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function addToken(body: any) {
    try {
        const url = `${process.env.TTD_URL}/tokens`
        const response = await fetch(url, {
            method: "POST",
            body: JSON.stringify(body),
            headers: {
                "Accept" : "application/json",
                "Content-Type": "application/json"
            }
        })

        const data = await response.json()

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function updateToken(id: string, body: any) {
    try {
        const url = `${process.env.TTD_URL}/tokens/${id}`
        const response = await fetch(url, {
            method: "PATCH",
            body: JSON.stringify(body),
            headers: {
                "Accept" : "application/json",
                "Content-Type": "application/json"
            }
        })

        const data = await response.json()

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function deleteToken(id: string) {
    try {
        const url = `${process.env.TTD_URL}/tokens/${id}`
        const response = await fetch(url, {
            method: "DELETE",
            headers: {
                "Accept" : "application/json",
            }
        })

        const data = await response.json()

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}