"use server"

export async function getProperties(offset: Number, search: String) {
    try {
        const body = {
            offset: offset,
            search: search
        }
        const url = `${process.env.BMV_URL}/api/paginated/properties`
        const response = await fetch(url, {
            method: "POST",
            body: JSON.stringify(body),
            headers: {
                "Accept" : "application/json",
                "Content-Type": "application/json"
            }
        })

        const data = await response.json()

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function getRawProperties() {
    try {
        const url = `${process.env.BMV_URL}/api/properties`

        const response = await fetch(url, {
            headers: {
                "Accept" : "application/json",
            }
        })

        const data = await response.json()

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function addProperties(body: any) {
    try {
        const url = `${process.env.BMV_URL}/api/properties`

        const response = await fetch(url, {
            method: "POST",
            body: JSON.stringify(body),
            headers: {
                "Accept" : "application/json",
                "Content-Type": "application/json"

            }
        })

        const data = await response.json()

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function oneProperties(id: string) {
    try {
        const url = `${process.env.BMV_URL}/api/properties/${id}`
        const response = await fetch(url, {
            headers: {
                "Accept" : "application/json",
            }
        })
        const data = await response.json();

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function updateProperties(id: string, bodyData: any) {
    try {
        const url = `${process.env.BMV_URL}/api/properties/${id}`
        const response = await fetch(url, {
            method: "PATCH",
            body: JSON.stringify(bodyData),
            headers: {
                "Accept" : "application/json",
                'Content-Type': 'application/json'
            }
        })

        const data = await response.json();

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function deleteProperties(id: string) {
    try {
        const url = `${process.env.BMV_URL}/api/properties/${id}`
        const response = await fetch(url, {
            method: "DELETE",
            headers: {
                "Accept" : "application/json",
            }
        })

        const data = await response.json();

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function updateStatus(id: string, body: any) {
    try {
        const url = `${process.env.BMV_URL}/api/properties/status/${id}`
        const response = await fetch(url, {
            method: "PATCH",
            body: JSON.stringify(body),
            headers: {
                "Accept" : "application/json",
                "Content-Type": "application/json"
            }
        })

        const data = await response.json();

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function updatePrice(id: string) {
    try {
        const url = `${process.env.BMV_URL}/api/properties/price/${id}`
        const response = await fetch(url, {
            headers: {
                "Accept" : "application/json",
            }
        })
        
        const data = await response.json();

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function getReservations(offset: Number, search: String) {
    try {
        const body = {
            offset: offset,
            search: search
        }
        const url = `${process.env.BMV_URL}/api/paginated/reservations`
        const response = await fetch(url, {
            method: "POST",
            body: JSON.stringify(body),
            headers: {
                "Accept" : "application/json",
                "Content-Type": "application/json"
            }
        })

        const data = await response.json()

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function deleteReservations(id: string) {
    try {
        const url = `${process.env.BMV_URL}/api/reservations/${id}`
        const response = await fetch(url, {
            method: "DELETE",
            headers: {
                "Accept" : "application/json",
            }
        })

        const data = await response.json()

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function bookReservations(body: any) {
    try {
        const url = `${process.env.BMV_URL}/api/webhook/booking`

        const response = await fetch(url, {
            method: "POST",
            body: JSON.stringify(body),
            headers: {
                "Accept" : "application/json",
                'Content-Type': "application/json"
            }
        })

        const data = await response.json()

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function getHistory(date: string) {
    try {
        const url = `${process.env.BMV_URL}/api/history?date=${date}`
        const response = await fetch(url, {
            headers: {
                "Accept" : "application/json",
            }
        })

        const data = await response.json()

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function getToken(offset: Number, search: String) {
    try {
        const body = {
            offset: offset,
            search: search
        }
        const url = `${process.env.BMV_URL}/api/paginated/tokens`
        const response = await fetch(url, {
            method: "POST",
            body: JSON.stringify(body),
            headers: {
                "Accept" : "application/json",
                "Content-Type": "application/json"
            }
        })

        const data = await response.json()

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function addToken(body: any) {
    try {
        const url = `${process.env.BMV_URL}/api/tokens`
        const response = await fetch(url, {
            method: "POST",
            body: JSON.stringify(body),
            headers: {
                "Accept" : "application/json",
                "Content-Type": "application/json"
            }
        })

        const data = await response.json()

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function updateToken(id: string, body: any) {
    try {
        const url = `${process.env.BMV_URL}/api/tokens/${id}`
        const response = await fetch(url, {
            method: "PATCH",
            body: JSON.stringify(body),
            headers: {
                "Accept" : "application/json",
                "Content-Type": "application/json"
            }
        })

        const data = await response.json()

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}

export async function deleteToken(id: string) {
    try {
        const url = `${process.env.BMV_URL}/api/tokens/${id}`
        const response = await fetch(url, {
            method: "DELETE",
            headers: {
                "Accept" : "application/json",
            }
        })

        const data = await response.json()

        return data
    } catch (error: any) {
        
        return { success: false, message: "An Error Occured"}
    }
}