'use server'

import { signIn, signOut } from "@/auth"
import { AuthError } from "next-auth";

export async function login(email: string, password: string) {
    try {

        const response = await signIn("credentials", {
            email,
            password,
            redirect: false
        });

        return { success: true , message:"",  url: response }
    } catch (error) {
        if (error instanceof AuthError) {
            switch ((error as any).type) {
                case "CredentialsSignin":
                return { success: false , message: "Invalid credentials!" };
                default:
                return { success: false , message: "Something went wrong!" };
            }
        }
    
        throw error;
    }
}


export async function logout(values: any) {
    await signOut({
        redirectTo: '/login',
    })
}